<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

    if ($inputData) {
        // Get form data from the decoded JSON
        $reportType = $inputData['report_type'];
        $duration = $inputData['duration'];
        $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
        $reportFormat = $inputData['report_format'];
        $startDate = $inputData['start_date'] ?? null;
        $endDate = $inputData['end_date'] ?? null;

        // If no columns are selected, default to all columns
        if (empty($columns)) {
            $columns = [
                'Date',
                'Type',
                'Sale Price',
                'Packaging Fee',
                'Delivery Fee',
                'Payment Charge',
                'Payment Discount',
                'Discount',
                'Round Discount',
                'Coupon Discount',
                'Total'
            ];
        }

        // Query to fetch data
        $query = "SELECT 
                    i.invoice_id, 
                    i.invoice_no,  
                    i.user_id, 
                    i.created_date AS invoice_date, 
                    i.Grand_total,
                    i.Total_price,
                    i.Total_discount,
                    i.Tax,
                    i.Roundoff,
                    i.Balance,
                    i.Shipping,
                    i.Discount,
                    i.Coupon_code,
                    i.Coupon_amount
                FROM 
                    invoice i
                WHERE 
                    i.Delete_status = 0";

        // Apply duration filters
        if ($duration == "Today") {
            $query .= " AND DATE(i.created_date) = CURDATE()";
        } elseif ($duration == "Yesterday") {
            $query .= " AND DATE(i.created_date) = CURDATE() - INTERVAL 1 DAY";
        } elseif ($duration == "Last Week") {
            $query .= " AND i.created_date >= NOW() - INTERVAL 1 WEEK";
        } elseif ($duration == "Last Month") {
            $query .= " AND i.created_date >= NOW() - INTERVAL 1 MONTH";
        } elseif ($duration == "Custom" && $startDate && $endDate) {
            $query .= " AND i.created_date BETWEEN '$startDate' AND '$endDate'";
        }

        // Perform the query using MySQLi
        $result = $conn->query($query);
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }

        // Generate the CSV file
        if ($reportFormat == "Xlsx") {
            $filePath = 'reports/order_summary_report_' . time() . '.csv';
            $file = fopen($filePath, 'w');

            // Write the header row based on the selected columns
            $header = $columns;
            fputcsv($file, $header);

            // Write data rows
            foreach ($data as $row) {
                $rowData = [];
                foreach ($columns as $column) {
                    switch ($column) {
                        case 'Date':
                            $rowData[] = $row['invoice_date'];
                            break;
                        case 'Type':
                            $rowData[] = 'invoice'; // Static value
                            break;
                        case 'Sale Price':
                            $rowData[] = $row['Total_price'];
                            break;
                        case 'Packaging Fee':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Delivery Fee':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Payment Charge':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Payment Discount':
                            $rowData[] = ''; // Placeholder
                            break;
                        case 'Discount':
                            $rowData[] = $row['Discount'];
                            break;
                        case 'Round Discount':
                            $rowData[] = $row['Roundoff'];
                            break;
                        case 'Coupon Discount':
                            $rowData[] = $row['Coupon_amount'];
                            break;
                        case 'Total':
                            $rowData[] = $row['Grand_total'];
                            break;
                        default:
                            $rowData[] = '';
                            break;
                    }
                }
                fputcsv($file, $rowData);
            }

            fclose($file);

            // Insert report details into the database
            $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
            $report_no_result = mysqli_query($conn, $report_no_query);
            $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
            $reportNo = 'REP_' . str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);
            $durationText = $duration ?? 'N/A';
            $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
            $insertQuery = "INSERT INTO reports (Report_no, report_name, date, Duration, Excel_path, Delete_status) 
                            VALUES ('$reportNo', 'Sales Summary Report', NOW(), '$durationText', '$finalpath', 0)";
            $conn->query($insertQuery);

            echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $finalpath]);
        } elseif ($reportFormat == "pdf") {
            $filePath = 'reports/order_summary_report_' . time() . '.pdf';

            // Create a new PDF document
            $pdf = new FPDF('L', 'mm', array(440, 300));
            $pdf->AddPage();
            $pdf->SetFont('Arial', 'B', 12);

            // Table headers
            $headers = $columns;

            // Set column widths
            $colWidths = array_fill(0, count($headers), 38); // Adjust column widths as needed
            $rowHeight = 8;

            // Print header row
            foreach ($headers as $index => $header) {
                $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
            }
            $pdf->Ln(); // Move to the next row

            // Print data rows
            foreach ($data as $row) {
                $values = [];
                foreach ($columns as $column) {
                    switch ($column) {
                        case 'Date':
                            $values[] = $row['invoice_date'];
                            break;
                        case 'Type':
                            $values[] = 'invoice'; // Static value
                            break;
                        case 'Sale Price':
                            $values[] = $row['Total_price'];
                            break;
                        case 'Packaging Fee':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Delivery Fee':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Payment Charge':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Payment Discount':
                            $values[] = ''; // Placeholder
                            break;
                        case 'Discount':
                            $values[] = $row['Discount'];
                            break;
                        case 'Round Discount':
                            $values[] = $row['Roundoff'];
                            break;
                        case 'Coupon Discount':
                            $values[] = $row['Coupon_amount'];
                            break;
                        case 'Total':
                            $values[] = $row['Grand_total'];
                            break;
                        default:
                            $values[] = '';
                            break;
                    }
                }

                foreach ($values as $index => $value) {
                    $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
                }
                $pdf->Ln(); // Move to the next row
            }

            // Save the PDF file
            $pdf->Output('F', $filePath);

            // Insert report details into the database
            $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
            $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
            $report_no_result = mysqli_query($conn, $report_no_query);
            $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
            $reportNo = 'REP_' . str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);
            $durationText = $duration ?? 'N/A';
            $insertQuery = "INSERT INTO reports (Report_no, report_name, date, Duration, Excel_path, Delete_status) 
                            VALUES ('$reportNo', 'Sales Summary Report', NOW(), '$durationText', '$finalpath', 0)";
            $conn->query($insertQuery);

            echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $finalpath]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
        }
    }
}
?>